<?php
require_once __DIR__ . '/config.php';

$requestUri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$method = $_SERVER['REQUEST_METHOD'];
$step = $_GET['step'] ?? 'username';

// Static file serving (if not handled by web server)
if (preg_match('/\.(css|js|png|jpg|jpeg|gif|svg|ico|woff|woff2)$/', $requestUri)) {
    $filePath = __DIR__ . $requestUri;
    if (file_exists($filePath)) {
        $ext = pathinfo($filePath, PATHINFO_EXTENSION);
        $mimeTypes = [
            'css' => 'text/css',
            'js' => 'application/javascript',
            'png' => 'image/png',
            'jpg' => 'image/jpeg',
            'jpeg' => 'image/jpeg',
            'gif' => 'image/gif',
            'svg' => 'image/svg+xml',
            'ico' => 'image/x-icon',
            'woff' => 'font/woff',
            'woff2' => 'font/woff2'
        ];
        header('Content-Type: ' . ($mimeTypes[$ext] ?? 'application/octet-stream'));
        readfile($filePath);
        exit;
    }
}

// Handle Username POST
if ($method === 'POST') {
    $username = $_POST['username'] ?? '';
    if (!empty($username)) {
        $_SESSION['login_username'] = $username;
        header('Location: ?step=password');
        exit;
    }
}

// Serve Views
if ($step === 'password') {
    include __DIR__ . '/password_view.php';
} else {
    include __DIR__ . '/index_view.php';
}
